/*
 ============================================================================
 Name        : Project_TheServer.c
 Author      : Tyler Mironuck
 Version     :
 Copyright   : Your copyright notice
 Description : Hello World in C, Ansi-style
 ============================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
//#include <arpa/inet.h>
#include <pthread.h>
#include <fcntl.h>
#include <sys/mman.h>

#define MSG_SIZE 40			// message size

struct sockaddr_in addr;
int sock, length, n;
socklen_t fromlen;
char userInput[MSG_SIZE];

struct Game_ID{
	char id[15];	//The ID of the game being used
	int status;		//Whether game is being used or not. 1=game in use, 0=not in use
	int score;		//represents the user's score. Each hit is 100 points
	int misses;		//How many misses the user accrued
	int level;		//The current level the user is on

};

//declare an array of struct Game_ID to hold the Status Report of each game
struct Game_ID game[2];

void error(const char *msg)
{
    perror(msg);
    exit(0);
}

void *Status_Of_Games(void *arguments){
	int i;
	printf("\n\nInstructions:\n");
	printf("At any time enter \"status\" to receive a status report of games. \n");

	while(1){
		fgets(userInput, MSG_SIZE, stdin);
		while( strncmp(userInput,"STATUS",6) && strncmp(userInput, "status", 6) ){
			printf("Please enter \"status\"\n");
			fgets(userInput, MSG_SIZE, stdin);
		}
		printf("\n\n\n\n\n\n\n\n\n\n\n");
		for(i=1;i<=20;i++){
			if(game[i].status == 1){
				printf("\nSTATUS REPORT\n");
				printf("=================================\n");
				printf("GAME ID %s IS IN USE\n", game[i].id);
				printf("CURRENT LEVEL: %d\n", game[i].level);
				printf("CURRENT SCORE: %d\n", game[i].score);
				printf("CURRENT MISSES: %d\n", game[i].misses);
				printf("=================================\n\n");
			}
		}
	}
	pthread_exit(0);
}

int main(int argc, char *argv[])
{
   int boolval = 1;			// for a socket option
   struct sockaddr_in server;
   char buffer[MSG_SIZE];	// to store received messages or messages to be sent.
   srand(time(NULL)); 	//randomize random number generator using current time
   char hostname[128], IP_Address[15], IP_Address_token[15];
   char received_IP[15], received_IP_token[15];
   int i;
   int my_ip_last_digit, recvd_ip_last_digit;
   int flag = 0;
   int bufTemp[2];
   char level[8];
   //If user forgets to include port when executing program
   if (argc < 2)
   {
	  printf("usage: %s port\n", argv[0]);
      exit(0);
   }

   gethostname(hostname, sizeof hostname);	//Retrieve local hostname of computer
   printf("My hostname: %s\n", hostname);	//Display hostname
   struct hostent *hstnm = gethostbyname(hostname);
   //Copy ip address into IP_address buffer in the
   /*The inet_ntoa function converts an ipv4 internet network address into an ASCII string in internet
    * standard dotted-decimal format as in the example "192.168.16.0".
    * h_addr is the member of struct hostent that holds the host address
    */
   strcpy(IP_Address, inet_ntoa(*((struct in_addr*)hstnm->h_addr)));	//Copy ip address into IP_Address array
   printf("My IP address is: %s\n", IP_Address);
   strcpy(IP_Address_token, IP_Address);

   //Tokenize IP_Address to get last digit
   strtok(IP_Address_token, ".");
   for(i=0; i<3; i++){
	   my_ip_last_digit = atoi(strtok(NULL,"."));
   }

   sock = socket(AF_INET, SOCK_DGRAM, 0); // Creates socket. Connectionless.
   if (sock < 0)
	   error("Opening socket");

   length = sizeof(server);			// length of structure
   bzero(&server,length);			// sets all values to zero. memset() could be used
   server.sin_family = AF_INET;		// symbol constant for Internet domain
   server.sin_addr.s_addr = INADDR_ANY;		// IP address of the machine on which
											// the server is running
   server.sin_port = htons(atoi(argv[1]));	// port number

   // binds the socket to the address of the host and the port number
   if (bind(sock, (struct sockaddr *)&server, length) < 0)
       error("binding");

   // change socket permissions to allow broadcast
   if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &boolval, sizeof(boolval)) < 0)
   	{
   		printf("error setting socket options\n");
   		exit(-1);
   	}

   fromlen = sizeof(struct sockaddr_in);	// size of structure

   pthread_t thread1;
   pthread_create(&thread1, NULL, Status_Of_Games, NULL);

   while(1)
   {
	   // to "clean up" the buffer. The messages aren't always the same length...
	   bzero(buffer,MSG_SIZE);

	   // receive from a client
	   n = recvfrom(sock, buffer, MSG_SIZE, 0, (struct sockaddr *)&addr, &fromlen);
       if (n < 0)
    	   error("recvfrom");

       strcpy(received_IP, inet_ntoa(addr.sin_addr.s_addr));

       strcpy(received_IP_token, received_IP);
       //printf("Message came from %s\n", received_IP);
       strtok(received_IP_token, ".");
          for(i=0; i<3; i++){
        	  recvd_ip_last_digit = atoi(strtok(NULL,"."));
       }
       printf("Message came from board number: %d\n",  recvd_ip_last_digit);
       if(strncmp(buffer,"#1",2) == 0){ //if message received is a game id status, store status
    	   strcpy(game[recvd_ip_last_digit].id, received_IP);
    	   game[recvd_ip_last_digit].status = 1;
    	   game[recvd_ip_last_digit].level = 1;
    	   //printf("Game ID %s is in use\n", buffer);
       }
       else if(strncmp(buffer,"#0",2) == 0){ //if message received is a game id status, store status
    	   game[recvd_ip_last_digit].status = 0;
    	   //printf("Game ID %s is in use\n", buffer);
       }
       else if( (strncmp(buffer,"$",1) == 0) ){		//if message received is a score, continue

			  if(strncmp(buffer, "$1", 2) == 0){
					  //printf("The user has scored. Broadcast to client game to move to level 2.\n");
					  game[recvd_ip_last_digit].level = 2;
					  game[recvd_ip_last_digit].score = 100;
					  //send message to the specific client (game) only
					  strcpy(level,"LEVEL2");	//build a string that holds number of wins
					  n = sendto(sock, level, strlen(level), 0,
					      		       		(struct sockaddr *)&addr, fromlen);
			  }
			  else if(strncmp(buffer, "$2", 2) == 0){
					  //printf("The user has scored twice. Broadcast to client game to move to level 3.\n");
					  game[recvd_ip_last_digit].level = 3;
					  game[recvd_ip_last_digit].score = 200;
					  //send message to the specific client (game) only
					  strcpy(level,"LEVEL3");	//build a string that holds number of wins
					  n = sendto(sock, level, strlen(level), 0,
											  (struct sockaddr *)&addr, fromlen);
			  }
			  else if(strncmp(buffer, "$3", 2) == 0){
					  //printf("The user has scored 3 times. Broadcast to client game to move to level 4.\n");
					  game[recvd_ip_last_digit].level = 4;
					  game[recvd_ip_last_digit].score = 300;
					  //send message to the specific client (game) only
					  strcpy(level,"LEVEL4");	//build a string that holds number of wins
					  n = sendto(sock, level, strlen(level), 0,
											  (struct sockaddr *)&addr, fromlen);
			  }
			  else if(strncmp(buffer, "$4", 2) == 0){
					  //printf("The user has scored 4 times. Broadcast to client game to move to level 5.\n");
					  game[recvd_ip_last_digit].level = 5;
					  game[recvd_ip_last_digit].score = 400;
					  //send message to the specific client (game) only
					  strcpy(level,"LEVEL5");	//build a string that holds number of wins
					  n = sendto(sock, level, strlen(level), 0,
											  (struct sockaddr *)&addr, fromlen);
			  }
			  else if(strncmp(buffer, "$5", 2) == 0){
					  //printf("The user has scored 5 times. Broadcast to client game that user has won.\n");
					  game[recvd_ip_last_digit].score = 500;
					  //send message to the specific client (game) only
					  strcpy(level,"END");	//build a string that holds number of wins
					  n = sendto(sock, level, strlen(level), 0,
											  (struct sockaddr *)&addr, fromlen);
			  }

       }
       else if(strncmp(buffer,"@",1) == 0){
			   int miss;
			   strtok(buffer, " ");		//begin tokenizing buffer by removing "@"
			   miss = atoi(strtok(NULL, " "));		//get next token which is the number of misses
			   game[recvd_ip_last_digit].misses = miss;
       }
       else {
    	   printf("Error: Received message is invalid. Learn how to type!\n");
       }

   }

   pthread_join(thread1, NULL);				//Wait for thread to finish
   return 0;
 }



